-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;




--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  KEY `idx1_catalog` (`super_catalog_idsuper_catalog`,`catalog_num`),
  KEY `idx2_catalog` (`super_catalog_idsuper_catalog`,`catalog_code`),
  KEY `idx3_catalog` (`group_num`,`super_catalog_idsuper_catalog`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`language`,`catalog_num`,`catalog_code`,`description`,`group_num`) VALUES 
 (1,1,'',0,'English','Inglés',NULL),
 (2,1,'',1,'Spanish','Español',NULL),
 (3,2,'English',0,'Public','',NULL),
 (4,2,'English',1,'Private','',NULL),
 (5,2,'Spanish',0,'Pública','',NULL),
 (6,2,'Spanish',1,'Privada','',NULL),
 (7,3,'English',0,'Not','',NULL),
 (8,3,'English',1,'Yes','',NULL),
 (9,3,'Spanish',0,'No','',NULL),
 (10,3,'Spanish',1,'Sí','',NULL);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE `companies` (
  `company_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone1` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `address1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `address2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `city` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `state` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `zip` varchar(11) COLLATE utf8_unicode_ci DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `owner` int(10) NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `private` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`company_id`),
  KEY `company_name` (`name`),
  KEY `company_owner` (`owner`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `companies`
--

/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`company_id`,`name`,`phone1`,`fax`,`address1`,`address2`,`city`,`state`,`zip`,`country`,`primary_url`,`owner`,`description`,`email`,`private`) VALUES 
 (0,'Función administrativa','','','','','','','','','',4,'','info@fhumanes.com',0),
 (3,'Company 1','','','','','','','','','',4,'Test','info@fhumanes.com',0);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`config_id`,`name`,`value`) VALUES 
 (1,'FOLDER_FILES','files'),
 (5,'EDITOR_BaseVirtual0','/postmanager/assets'),
 (6,'EDITOR_Base0','C:/Apache24/htdocs/postmanager/assets'),
 (7,'GMAIL_Username','fhumanes.pruebas@gmail.com'),
 (8,'GMAIL_Password','The real key has not been set. But here must be the password'),
 (9,'GMAIL_setFrom_email','info@fhumanes.com'),
 (10,'GMAIL_setFrom_name','Fernando Humanes'),
 (11,'EDITOR_UrlBase0','http://localhost/postmanager/assets');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `contact`
--

DROP TABLE IF EXISTS `contact`;
CREATE TABLE `contact` (
  `contact_id` int(10) NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `surname` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `userLastUpdate` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `dateLastUpdate` datetime NOT NULL,
  PRIMARY KEY (`contact_id`),
  KEY `user_username` (`name`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_contacts_companies` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `contact`
--

/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
INSERT INTO `contact` (`contact_id`,`companies_company_id`,`departments_dept_id`,`name`,`surname`,`email`,`userLastUpdate`,`dateLastUpdate`) VALUES 
 (7,3,1,'Fernando','Humanes','info@fhumanes.com','admin','2020-05-09 13:16:40'),
 (8,3,2,'Fernando','Humanes (2)','fhumanes.pruebas@gmail.com','admin','2020-05-09 13:20:34'),
 (9,3,1,'Test1','Test1','info@fhumanes.com','admin','2020-05-11 18:24:56');
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;


--
-- Definition of table `departments`
--

DROP TABLE IF EXISTS `departments`;
CREATE TABLE `departments` (
  `dept_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`dept_id`),
  KEY `dept_name` (`name`),
  KEY `fk_departments_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_departments_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Department heirarchy under a company';

--
-- Dumping data for table `departments`
--

/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`dept_id`,`companies_company_id`,`name`,`phone`,`fax`,`desc`,`email`) VALUES 
 (1,3,'Departament 1','','','','info@fhumanes.com'),
 (2,3,'Departament 2','','','','info@fhumanes.com');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;


--
-- Definition of table `email`
--

DROP TABLE IF EXISTS `email`;
CREATE TABLE `email` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(200) NOT NULL,
  `message` longtext,
  `attachments` varchar(600) DEFAULT NULL,
  `userLastUpdate` varchar(16) DEFAULT NULL,
  `dateLastUpdate` datetime DEFAULT NULL,
  PRIMARY KEY (`email_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `email`
--

/*!40000 ALTER TABLE `email` DISABLE KEYS */;
INSERT INTO `email` (`email_id`,`subject`,`message`,`attachments`,`userLastUpdate`,`dateLastUpdate`) VALUES 
 (3,'Funcionality test','<div><img src=\"/postmanager/assets/pajaros_2.jpg\" title=\"fernando\" alt=\"fernando\" style=\"margin-bottom: 5px; margin-right: 5px;\" width=\"250\" height=\"250\" border=\"0\" align=\"left\">Esto es una prueba para comprobar el funcionamiento</div><div>áéíúyó´ñÑÁÉÍÓÚ<br></div><div><br></div><div><br></div><div><br></div><div><br></div>																										','[{\"name\":\"files\\/Municipios-50_k13i565l.pdf\",\"usrName\":\"Municipios-50.pdf\",\"size\":91726,\"type\":\"application\\/pdf\",\"searchStr\":\"Municipios-50.pdf,!Gestor de proyectos en PHPrunner.docx,!:sStrEnd\"},{\"name\":\"files\\/Gestor de proyectos en PHPrunner_8ekdhsch.docx\",\"usrName\":\"Gestor de proyectos en PHPrunner.docx\",\"size\":447159,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\"}]','admin','2020-05-11 19:18:38'),
 (4,'Paste from Word','<p class=\"MsoNormal\" style=\"text-align:center\" align=\"center\"><span style=\"text-decoration: underline;\">APP PHPRunnercliente RESTfull API</span></p><p class=\"MsoNormal\" align=\"justify\"><span style=\"font-weight: bold;\">Personalización de los datos del usuario:</span></p><p class=\"MsoNormal\" align=\"justify\">User: <span style=\"font-weight: bold;\">{name} {surname}</span></p><p class=\"MsoNormal\" align=\"justify\">Email: <span style=\"font-weight: bold;\">{email}</span><br><span style=\"text-decoration: underline;\"></span><span style=\"text-decoration: underline;\">&nbsp;</span></p><p class=\"MsoNormal\" style=\"text-align:justify\"><span style=\"font-weight: bold;\">Wikipedia. Definición</span></p><p class=\"MsoNormal\" style=\"text-align:justify;line-height:normal\">La <span style=\"font-weight: bold;\">transferenciade estado representacional</span> (en inglés <span style=\"font-style: italic;\">representational state transfer</span>)o <span style=\"font-weight: bold;\">REST</span> es un estilo de arquitectura <span style=\"font-style: italic;\">software</span> para sistemas hipermediadistribuidos como la World Wide Web. El término se originó en el año 2000, enuna tesis doctoral sobre la web escrita por Roy Fielding, uno de losprincipales autores de la especificación del protocolo HTTP y ha pasado a serampliamente utilizado por la comunidad de desarrollo.</p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">Si bien el término <span style=\"font-style: italic;\">REST</span> se referíaoriginalmente a un conjunto de principios de arquitectura, en la actualidad seusa en el sentido más amplio para describir cualquier interfaz entre sistemasque utilice directamente HTTP para obtener datos o indicar la ejecución de operacionessobre los datos, en cualquier formato (XML, JSON, etc.) sin las abstraccionesadicionales de los protocolos basados en patrones de intercambio de mensajes,como por ejemplo SOAP. Es posible diseñar sistemas de servicios web de acuerdocon el estilo arquitectural REST de Fielding y también es posible diseñarinterfaces XMLHTTP de acuerdo con el estilo de llamada a procedimiento remoto(RPC), pero sin usar SOAP. Estos dos usos diferentes del término REST causancierta confusión en las discusiones técnicas, aunque RPC no es un ejemplo deREST. </span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">REST afirma que la web ha disfrutado de escalabilidad como resultado de unaserie de diseños fundamentales clave: </span></p><ul type=\"disc\"><li class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;     text-align:justify;line-height:normal;mso-list:l1 level1 lfo1;tab-stops:     list 36.0pt\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;     mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:     ES\">Un <span style=\"font-weight: bold;\">protocolo cliente/servidor </span><span style=\"font-weight: bold;\">sin estado</span>: cada mensaje HTTP contiene toda la información     necesaria para comprender la petición. Como resultado, ni el cliente ni el     servidor necesitan recordar ningún estado de las comunicaciones entre     mensajes. Sin embargo, en la práctica, muchas aplicaciones basadas en HTTP     utilizan cookies y otros mecanismos para mantener el estado de la sesión     (algunas de estas prácticas, como la reescritura de URLs, no son     permitidas por REST)</span></li></ul><ul type=\"disc\"><li class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;     text-align:justify;line-height:normal;mso-list:l2 level1 lfo2;tab-stops:     list 36.0pt\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;     mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:     ES\">Un conjunto de <span style=\"font-weight: bold;\">operaciones bien definidas</span> que se aplican a     todos los <span style=\"font-style: italic;\">recursos</span> de información: HTTP en sí define un conjunto     pequeño de operaciones, las más importantes son <span style=\"font-weight: bold;\">POST</span>, <span style=\"font-weight: bold;\">GET</span>, <span style=\"font-weight: bold;\">PUT</span>     y <span style=\"font-weight: bold;\">DELETE</span>. Con frecuencia estas operaciones se equiparan a las     operaciones CRUD en bases de datos (CLAB en castellano: crear, leer, actualizar,     borrar) que se requieren para la persistencia de datos, aunque POST no     encaja exactamente en este esquema.</span></li></ul><ul type=\"disc\"><li class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;     line-height:normal;mso-list:l0 level1 lfo3;tab-stops:list 36.0pt\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:     Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">Una <span style=\"font-weight: bold;\">sintaxis     universal</span> para identificar los recursos. En un sistema REST, cada     recurso es direccionable únicamente a través de su URI.</span></li></ul><ul type=\"disc\"><li class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;     text-align:justify;line-height:normal;mso-list:l3 level1 lfo4;tab-stops:     list 36.0pt\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;     mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:     ES\">El <span style=\"font-weight: bold;\">uso de hipermedios</span>, tanto para la información de la     aplicación como para las transiciones de estado de la aplicación: la     representación de este estado en un sistema REST son <span style=\"font-weight: bold;\">típicamente HTML o     XML.</span> Como resultado de esto, es posible navegar de un recurso REST a     muchos otros, simplemente siguiendo enlaces sin requerir el uso de     registros u otra infraestructura adicional.</span></li></ul><span style=\"font-size:11.0pt;line-height:115%;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-ascii-theme-font:minor-latin;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin;mso-ansi-language:ES;mso-fareast-language:ES;mso-bidi-language:AR-SA\"></span><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES;mso-no-proof:yes\"><br></span><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\"></span><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">En esta imagen se reflejan los principales usos de losservicios REST. Como podéis comprobar hay 2 formas de usarlos.</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">(1).- Es la forma más habitual. Las aplicaciones APP(Android e IOS) consumen los datos y objetos de negocios que le ofrecen losservidores de las empresas. También, los navegadores (Chrome, Firefox, MS Edge,Opera, etc.) son cliente de estos servicios, utilizando estos desde el lenguajede java script.</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">(2).- Esta es la forma que utiliza PHPRunner. En estecaso es una aplicación del servidor (PHP) quién utiliza los servicios paradespués presentar los datos en un navegador.</span></p><a href=\"https://fhumanes.com/covid_19\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\"></span></a><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\"></span><div><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"font-weight: bold;\">Publicación deservicios RESTfull API</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">Prácticamente todas las administraciones públicasdisponen de sus publicaciones de datos abiertos y es muy normal que estos seofrezcan en formato JSON.</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><a href=\"https://datos.gob.es/\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">https://datos.gob.es/</span></a><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\"> es la web de estos datosdel gobierno de España.</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">También existen otras empresas que ofrecen datos queellos recopilan y para facilitar el uso de los mismos lo ofrecen a través deeste protocolo/arquitectura. </span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><a href=\"https://rapidapi.com/\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">https://rapidapi.com/</span></a><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\"> es un ejemplo y esdonde he accedido a los datos de un servicio gratis que ofrece los datos delCOVID 19 de todo el mundo. </span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><a href=\"https://rapidapi.com/api-sports/api/covid-193\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">https://rapidapi.com/api-sports/api/covid-193</span></a><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\"></span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">&nbsp;</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"font-weight: bold;\">DEMO</span><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">: </span><a href=\"https://fhumanes.com/covid_19\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">https://fhumanes.com/covid_19</span></a><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\"></span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">&nbsp;</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"font-weight: bold;\">¿Qué tiene el ejemplo?</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">La aplicación lo que quiere mostrar es un ejemplocompleto que muestre las funcionalidades nuevas que incorpora la versión 10.4,ahí es donde más me extenderé, para que pueda servir de ayuda a aquellos devosotros que deseéis probar estas funcionalidades.</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">También, y como complemento, os mostraré que podemosacceder a estos datos y mostrarlos en tablas “temporales” y podréis apreciarque todo funciona muy rápido. Esta funcionalidad también puede ser importanteporque no requiere de la versión 10.4 y se puede utilizar desde cualquierversión de PHPRunner.</span></p><p class=\"MsoNormal\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;text-align:justify;line-height:normal\"><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">El Servidor tiene 3 métodos:</span></p><p class=\"MsoListParagraphCxSpFirst\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;margin-left:1.0cm;mso-add-space:auto;text-align:justify;text-indent:-14.15pt;line-height:normal;mso-list:l0 level2 lfo1\"><span style=\"mso-ascii-font-family:Calibri;mso-fareast-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:Calibri;mso-fareast-language:ES\"><span style=\"mso-list:Ignore\">-<span style=\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">Coutries . Facilita el nombre de todos los países.</span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;margin-left:1.0cm;mso-add-space:auto;text-align:justify;text-indent:-14.15pt;line-height:normal;mso-list:l0 level2 lfo1\"><span style=\"mso-ascii-font-family:Calibri;mso-fareast-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:Calibri;mso-fareast-language:ES\"><span style=\"mso-list:Ignore\">-<span style=\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">Statistics. Facilita la situación actual de Covid 19 en todos los países.</span></p><p class=\"MsoListParagraphCxSpLast\" style=\"mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;margin-left:1.0cm;mso-add-space:auto;text-align:justify;text-indent:-14.15pt;line-height:normal;mso-list:l0 level2 lfo1\"><span style=\"mso-ascii-font-family:Calibri;mso-fareast-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:Calibri;mso-fareast-language:ES\"><span style=\"mso-list:Ignore\">-<span style=\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;mso-fareast-language:ES\">History. Facilita la información de cualquier país a una fecha anterior ahoy.</span></p><!--[if gte mso 9]><xml> <w:WordDocument>  <w:View>Normal</w:View>  <w:Zoom>0</w:Zoom>  <w:TrackMoves/>  <w:TrackFormatting/>  <w:HyphenationZone>21</w:HyphenationZone>  <w:PunctuationKerning/>  <w:ValidateAgainstSchemas/>  <w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid>  <w:IgnoreMixedContent>false</w:IgnoreMixedContent>  <w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText>  <w:DoNotPromoteQF/>  <w:LidThemeOther>ES</w:LidThemeOther>  <w:LidThemeAsian>X-NONE</w:LidThemeAsian>  <w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript>  <w:Compatibility>   <w:BreakWrappedTables/>   <w:SnapToGridInCell/>   <w:WrapTextWithPunct/>   <w:UseAsianBreakRules/>   <w:DontGrowAutofit/>   <w:SplitPgBreakAndParaMark/>   <w:DontVertAlignCellWithSp/>   <w:DontBreakConstrainedForcedTables/>   <w:DontVertAlignInTxbx/>   <w:Word11KerningPairs/>   <w:CachedColBalance/>  </w:Compatibility>  <m:mathPr>   <m:mathFont m:val=\"Cambria Math\"/>   <m:brkBin m:val=\"before\"/>   <m:brkBinSub m:val=\"--\"/>   <m:smallFrac m:val=\"off\"/>   <m:dispDef/>   <m:lMargin m:val=\"0\"/>   <m:rMargin m:val=\"0\"/>   <m:defJc m:val=\"centerGroup\"/>   <m:wrapIndent m:val=\"1440\"/>   <m:intLim m:val=\"subSup\"/>   <m:naryLim m:val=\"undOvr\"/>  </m:mathPr></w:WordDocument></xml><![endif]--><!--[if gte mso 9]><xml> <w:LatentStyles DefLockedState=\"false\" DefUnhideWhenUsed=\"true\"  DefSemiHidden=\"true\" DefQFormat=\"false\" DefPriority=\"99\"  LatentStyleCount=\"267\">  <w:LsdException Locked=\"false\" Priority=\"0\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Normal\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"heading 1\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 2\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 3\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 4\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 5\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 6\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 7\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 8\"/>  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 9\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 1\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 2\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 3\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 4\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 5\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 6\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 7\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 8\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 9\"/>  <w:LsdException Locked=\"false\" Priority=\"35\" QFormat=\"true\" Name=\"caption\"/>  <w:LsdException Locked=\"false\" Priority=\"10\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Title\"/>  <w:LsdException Locked=\"false\" Priority=\"1\" Name=\"Default Paragraph Font\"/>  <w:LsdException Locked=\"false\" Priority=\"11\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Subtitle\"/>  <w:LsdException Locked=\"false\" Priority=\"22\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Strong\"/>  <w:LsdException Locked=\"false\" Priority=\"20\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Emphasis\"/>  <w:LsdException Locked=\"false\" Priority=\"59\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Table Grid\"/>  <w:LsdException Locked=\"false\" UnhideWhenUsed=\"false\" Name=\"Placeholder Text\"/>  <w:LsdException Locked=\"false\" Priority=\"1\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"No Spacing\"/>  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Shading\"/>  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light List\"/>  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Grid\"/>  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1\"/>  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2\"/>  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 1\"/>  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 2\"/>  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1\"/>  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2\"/>  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3\"/>  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Dark List\"/>  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Shading\"/>  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful List\"/>  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Grid\"/>  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light List Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 1\"/>  <w:LsdException Locked=\"false\" UnhideWhenUsed=\"false\" Name=\"Revision\"/>  <w:LsdException Locked=\"false\" Priority=\"34\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"List Paragraph\"/>  <w:LsdException Locked=\"false\" Priority=\"29\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Quote\"/>  <w:LsdException Locked=\"false\" Priority=\"30\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Intense Quote\"/>  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 1\"/>  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light List Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 2\"/>  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light List Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 3\"/>  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light List Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 4\"/>  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light List Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 5\"/>  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light List Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 6\"/>  <w:LsdException Locked=\"false\" Priority=\"19\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Subtle Emphasis\"/>  <w:LsdException Locked=\"false\" Priority=\"21\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Intense Emphasis\"/>  <w:LsdException Locked=\"false\" Priority=\"31\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Subtle Reference\"/>  <w:LsdException Locked=\"false\" Priority=\"32\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Intense Reference\"/>  <w:LsdException Locked=\"false\" Priority=\"33\" SemiHidden=\"false\"   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Book Title\"/>  <w:LsdException Locked=\"false\" Priority=\"37\" Name=\"Bibliography\"/>  <w:LsdException Locked=\"false\" Priority=\"39\" QFormat=\"true\" Name=\"TOC Heading\"/> </w:LatentStyles></xml><![endif]--><!--[if gte mso 10]><style> /* Style Definitions */ table.MsoNormalTable	{mso-style-name:\"Tabla normal\";	mso-tstyle-rowband-size:0;	mso-tstyle-colband-size:0;	mso-style-noshow:yes;	mso-style-priority:99;	mso-style-qformat:yes;	mso-style-parent:\"\";	mso-padding-alt:0cm 5.4pt 0cm 5.4pt;	mso-para-margin-top:0cm;	mso-para-margin-right:0cm;	mso-para-margin-bottom:10.0pt;	mso-para-margin-left:0cm;	line-height:115%;	mso-pagination:widow-orphan;	font-size:11.0pt;	font-family:\"Calibri\",\"sans-serif\";	mso-ascii-font-family:Calibri;	mso-ascii-theme-font:minor-latin;	mso-hansi-font-family:Calibri;	mso-hansi-theme-font:minor-latin;	mso-bidi-font-family:\"Times New Roman\";	mso-bidi-theme-font:minor-bidi;	mso-fareast-language:EN-US;}</style><![endif]--></div><div><br></div>				','','admin','2020-05-11 19:17:17');
/*!40000 ALTER TABLE `email` ENABLE KEYS */;


--
-- Definition of table `email_contact`
--

DROP TABLE IF EXISTS `email_contact`;
CREATE TABLE `email_contact` (
  `idemail_contact` int(11) NOT NULL AUTO_INCREMENT,
  `email_email_id` int(11) NOT NULL,
  `contact_contact_id` int(10) NOT NULL,
  `email` varchar(70) DEFAULT NULL,
  `dateEmail` datetime DEFAULT NULL,
  `Status` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`idemail_contact`),
  KEY `fk_email_contact_email1_idx` (`email_email_id`),
  KEY `fk_email_contact_contact1_idx` (`contact_contact_id`),
  CONSTRAINT `fk_email_contact_contact1` FOREIGN KEY (`contact_contact_id`) REFERENCES `contact` (`contact_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_email_contact_email1` FOREIGN KEY (`email_email_id`) REFERENCES `email` (`email_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `email_contact`
--

/*!40000 ALTER TABLE `email_contact` DISABLE KEYS */;
INSERT INTO `email_contact` (`idemail_contact`,`email_email_id`,`contact_contact_id`,`email`,`dateEmail`,`Status`) VALUES 
 (12,3,7,'info@fhumanes.com','2020-05-11 20:37:00','1'),
 (13,3,8,'fhumanes.pruebas@gmail.com','2020-05-11 18:16:39','1'),
 (16,4,7,'info@fhumanes.com','2020-05-11 18:40:56','1'),
 (17,4,8,'fhumanes.pruebas@gmail.com','2020-05-11 18:40:58','1'),
 (18,4,9,'info@fhumanes.com','2020-05-11 18:41:00','1');
/*!40000 ALTER TABLE `email_contact` ENABLE KEYS */;


--
-- Definition of table `postmanager_settings`
--

DROP TABLE IF EXISTS `postmanager_settings`;
CREATE TABLE `postmanager_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `postmanager_settings`
--

/*!40000 ALTER TABLE `postmanager_settings` DISABLE KEYS */;
INSERT INTO `postmanager_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":696.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":195.4,\"grid_headcell_field2\":399.4}}','config'),
 (2,2,NULL,'admin',NULL,'{\"gridWidth\":1089.4,\"thWidths\":{\"grid_headcell_icons\":34.4,\"grid_headcell_checkbox\":30.4,\"grid_headcell_details\":27.4,\"grid_headcell_field\":21.4,\"grid_headcell_field1\":153.4,\"grid_headcell_field2\":359.4,\"grid_headcell_field3\":240.4,\"grid_headcell_field4\":146.4}}','email'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":848.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":12.399999999999999,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":88.4,\"grid_headcell_field2\":97.4,\"grid_headcell_field3\":48.4,\"grid_headcell_field4\":88.4,\"grid_headcell_field5\":163.4,\"grid_headcell_field6\":97.4,\"grid_headcell_field7\":122.4}}','contact'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":537.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":58.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":149.4,\"grid_headcell_field2\":42.4,\"grid_headcell_field6\":20.4,\"grid_headcell_field11\":59.4,\"grid_headcell_field12\":64.4}}','companies'),
 (5,2,NULL,'admin',NULL,'{\"gridWidth\":944.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":11.399999999999999,\"grid_headcell_field1\":216.4,\"grid_headcell_field2\":189.4,\"grid_headcell_field5\":158.4,\"grid_headcell_field6\":169.4,\"grid_headcell_field7\":76.4}}','email_contact');
/*!40000 ALTER TABLE `postmanager_settings` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`),
  UNIQUE KEY `super_catalog_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`super_code`,`description`) VALUES 
 (1,'LANGUAGE','Languages of the literals'),
 (2,'COMPANY','Type of Companies'),
 (3,'DECISION','Affirmative and negative');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `signature` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color_identifier` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '#FFFFFF',
  `reset_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_username` (`username`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  KEY `user_login` (`login`),
  CONSTRAINT `fk_users_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`user_id`,`login`,`companies_company_id`,`departments_dept_id`,`username`,`password`,`signature`,`email`,`color_identifier`,`reset_token`,`reset_date`) VALUES 
 (4,'admin',3,NULL,'Admistrator','21232f297a57a5a743894a0e4a801fc3',NULL,'info@fhumanes.com','#FFFFFF',NULL,NULL),
 (5,'user1',3,1,'User 1','24c9e15e52afc47c225b757e7bee1f9d',NULL,'','#E31C1C',NULL,NULL),
 (6,'user2',3,NULL,'User 2','7e58d63b60197ceb55a1c487989a3720',NULL,'','#1944D1',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
